//
//  CalculatorTest.m
//  TDD Example
//
//  Created by Dennis Lewandowski on 3/14/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "CalculatorTest.h"


@implementation CalculatorTest

#if USE_APPLICATION_UNIT_TEST     // all code under test is in the iPhone Application

- (void) testAppDelegate {
    
    id yourApplicationDelegate = [[UIApplication sharedApplication] delegate];
    STAssertNotNil(yourApplicationDelegate, @"UIApplication failed to find the AppDelegate");
    
}

#else                           // all code under test must be linked into the Unit Test bundle

- (void) testMath {
    
    STAssertTrue((1+1)==2, @"Compiler isn't feeling well today :-(" );
    
}


- (void)testCalculator
{
    // initialize the calculator
	Calculator* calc = [[Calculator alloc] init];
	int expected = 11;

	// run the method and save the result
    int result = [calc add:5 to:6];
	
    // compare the result to what we have expected
	STAssertEquals(expected, result, @"Wrong return value. Got %d, expected %d", result, expected);

	[calc release];
}


-(void)testCloudCalculator
{
    // initialize the calculator and set us as the delegate
	Calculator *calc = [[Calculator alloc] init];
	calc.delegate = self;

    // run the method and tell the runloop to wait for a second
	[calc cloudAdd:5 to:6];
	[self waitForDelegateCallback:1];
	
	int expected = 11;
	
    // compare the result to what we have expected
	STAssertEquals(expected, remoteResult, @"Result does not match expectations. Got %d, expected %d", remoteResult, expected);
	
	[calc release];
}

#endif


# pragma mark -
# pragma mark Calculator delegate methods

-(void)calculator:(Calculator *)theCalculator didFinishWithResult:(int)theResult
{
    // save the result of the calculation
	remoteResult = theResult;
}


# pragma mark -
# pragma mark Helper methods

-(void)waitForDelegateCallback:(NSTimeInterval)seconds
{
    // lets the runloop wait for a given time
	NSDate* nSecondsFromNow = [NSDate dateWithTimeIntervalSinceNow:seconds];
	[[NSRunLoop currentRunLoop] runUntilDate:nSecondsFromNow];
}

@end
